clear
clc
addpath('RNTK/')
addpath('NTK/')
addpath('Poly/')
addpath('RBF/')
addpath('util/')
addpath('libsvm/')
%% 
k = 10; %k fold% validation
%% Loading data
experiment ='PowerCons';

X_train = load(strcat('datasets/', experiment, '/X_train_raw.mat')); 
y_train = load(strcat('datasets/', experiment, '/y_train_raw.mat')); 
X_test = load(strcat('datasets/', experiment, '/X_test_raw.mat')); 
y_test = load(strcat('datasets/', experiment, '/y_test_raw.mat')); 

X_train = X_train.data;
y_train = double(y_train.data)';
X_test = X_test.data;
y_test = double(y_test.data)';

for i = 1:size(X_train,1)
    X_train(i,:) = X_train(i,:)/norm(X_train(i,:));
end
for i = 1:size(X_test,1)
    X_test(i,:) = X_test(i,:)/norm(X_test(i,:));
end

x = X_train;
y = y_train;
%% 
results = struct();
results.experiment = experiment;
results.ntrain = size(X_train,1);
results.ntest = size(X_test,1);
results.T = size(X_train,2);
%% Partitions of cross validation
id = crossvalind('Kfold', size(x,1) , k);
%% RNTK
rntkresult = best_result_rntk(x,y,id);
kernel_train = newgramRNTK(X_train,X_train,rntkresult.param);
kernel_test = newgramRNTK(X_test,X_train,rntkresult.param);
model = svmtrain(y_train, [(1:size(kernel_train,1))',kernel_train], rntkresult.svmparam);
[~, acc_rntk, ~] = svmpredict(y_test, [(1:size(kernel_test,1))',kernel_test], model);
rntkresult.acc = acc_rntk(1);
results.rntk = rntkresult;
%% NTK
ntkresult = best_result_ntk(x,y,id);
kernel_train = gramNTK(X_train,X_train,ntkresult.param);
kernel_test = gramNTK(X_test,X_train,ntkresult.param);
model = svmtrain(y_train, [(1:size(kernel_train,1))',kernel_train], ntkresult.svmparam);
[~, acc_ntk, ~] = svmpredict(y_test, [(1:size(kernel_test,1))',kernel_test], model);
ntkresult.acc = acc_ntk(1);
results.ntk = ntkresult;
%% RBF
rbfresult = best_result_rbf(x,y,id);
kernel_train = gramRBF(X_train,X_train,rbfresult.alpha);
kernel_test = gramRBF(X_test,X_train,rbfresult.alpha);
model = svmtrain(y_train, [(1:size(kernel_train,1))',kernel_train], rbfresult.svmparam);
[~, acc_rbf, ~] = svmpredict(y_test, [(1:size(kernel_test,1))',kernel_test], model);
rbfresult.acc = acc_rbf(1);
results.rbf = rbfresult;
%% Poly
polyresult = best_result_poly(x,y,id);
kernel_train = gramPOLY(X_train,X_train,polyresult.d,polyresult.r);
kernel_test = gramPOLY(X_test,X_train,polyresult.d,polyresult.r);
model = svmtrain(y_train, [(1:size(kernel_train,1))',kernel_train], polyresult.svmparam);
[~, acc_poly, ~] = svmpredict(y_test, [(1:size(kernel_test,1))',kernel_test], model);
polyresult.acc = acc_poly(1);
results.poly = polyresult; 
%%
fprintf(['For experiment ',experiment, '\n'])
fprintf('rntk acc = %.2f, ntk acc = %.2f, rbf acc = %.2f, poly acc = %0.2f, \n', results.rntk.acc, results.ntk.acc,results.rbf.acc,results.poly.acc)
save(['results/' experiment 'results' '.mat'], 'results')
